﻿#ifndef FMP_EPAY_I_H
#define FMP_EPAY_I_H

#include <fmp_plugin_i.h>

#include "fmp_epay_def.h"


/**
 * 业务插件接口，必须继承自 FMPluginInterface
 * @brief The FMPePayInterface class
 */
class FMPePayInterface : public QObject, public FMPluginInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPluginInterface)
public:
    explicit            FMPePayInterface(ctkPluginContext *ctx) : FMPluginInterface(ctx)
    {
        connect(this, &FMPePayInterface::TriggerInit, this, &FMPePayInterface::OnTriggerInit);
        connect(this, &FMPePayInterface::TriggerUninit, this, &FMPePayInterface::OnTriggerUninit);
    }

signals:
    void                TriggerInit();
    void                TriggerUninit();

protected slots:
    void                OnTriggerInit() { FMPluginInterface::OnTriggerInit(); }
    void                OnTriggerUninit() { FMPluginInterface::OnTriggerUninit(); }
//    /**
//     * @brief ShowPayDialog
//     * 呈现支付主界面
//     * @return
//     */
//    virtual int             ShowPayDialog() = 0;

//    /**
//     * @brief ControlPayJson
//     * 获取发送支付请求
//     * @param sum
//     * @param code
//     */
//     virtual void ControlPayJson(QString sum, QString code) = 0;


//    /**
//     * @brief ControlRefundJson
//     * 获取发送退款请求
//     * @param sum
//     * @param code(fmID/pay_transId)
//     */
//     virtual void ControlRefundJson(QString sum, QString code) = 0;

//    /**
//     * @brief ControlReverseJson
//     * 冲正
//     */
//     virtual void ControlReverseJson() = 0;




};

Q_DECLARE_INTERFACE(FMPePayInterface, "com.fmp.epay")


#endif // FMP_LOGGER_I_H
