﻿#include "fmp_epay_p.h"
#include "fmp_epay_def.h"
#include "fmp_pe_handlers.h"
#include <QDateTime>

class ctkPluginContext;

FMPePay::FMPePay(ctkPluginContext *context)
    : FMPePayInterface(context),
      //_url(DEFAULT_EPAY_RWQUESTURL),
      _inited(false),
      //_needanimation(false),
      _partner_id(QString("")),
      _databasename(DEFAULT_EPAY_DATABASENAME),
      _table(DEFAULT_EPAY_TABLE),
      _businessdate(QDateTime::currentDateTime().toString("yyyy-MM-dd")),
      _ordershelflife(DEFAULT_EPAY_ORDERLIFE),
      _operator_id(DEFAULT_EPAY_OPTID),
      _store_id(DEFAULT_EPAY_STRID),
      _station_id(DEFAULT_EPAY_STNID),
      _time_out(60),
      _ste_handler(new FMPStartEventHandler(_ctx, this)),
      d_ptr(new FMPePayPrivate(this))
{
}

FMPePay::~FMPePay()
{
    StopService();

    if (d_ptr) {
        delete d_ptr;
        d_ptr = nullptr;
    }
}

void FMPePay::InitService()
{
    if (_inited) return;

    Q_D(FMPePay);
    d->Init();
}

void FMPePay::UninitService()
{
    if (_inited) {
        Q_D(FMPePay);
        d->Uninit();
    }
}

void FMPePay::SetBasicInfo(QVariantHash hash)
{
    Q_D(FMPePay);
    this->_businessdate = hash[FMP_BASIC_BUSINESSDATE].toString();
    d->SetBasicInfo(hash);
}
