﻿/*
 * Copyright (c) 2016, 上海非码网络科技有限公司
 * All rights reserved.
 *
 */
#ifndef FMP_PLUGIN_I_H
#define FMP_PLUGIN_I_H

#include <fmp_base_i.h>
#include <fmp_logger_i.h>
#include <ctkPluginContext.h>
#include <service/event/ctkEventAdmin.h>

class ctkPluginContext;

class FMPluginInterface : public FMPBaseInterface
{
public:
    explicit        FMPluginInterface(ctkPluginContext *ctx) : _ctx(ctx){}

    int             StartService()
    {
        QString topic = FMP_TOPICS_SERVICES;
        topic += FMPE_SERVICE_REQ_START;
        topic += "/" + QString::number(_ctx->getPlugin()->getPluginId());
        return PostEvent(topic);
    }

protected:
    int             PostEvent(const QString &topic, const FMPProps &pps = FMPProps())
    {
        ctkEventAdmin *event_admin = GetService<ctkEventAdmin>(_ctx);
        if (event_admin) {
            ctkEvent ctk_event(topic, pps);
            event_admin->postEvent(ctk_event);
            FMP_INFO_CTX(_ctx) << "Posted event" << topic << "Properties:" << pps;
            return FMP_SUCCESS;
        }
        else {
            FMP_WARN_CTX(_ctx) << topic << "not send: Event admin not available.";
        }

        return FMP_FAILURE;
    }

protected:
    ctkPluginContext   *_ctx;
};

Q_DECLARE_INTERFACE(FMPluginInterface, "com.fmp.plugin")


#endif // FMP_PLUGIN_I_H
