﻿/*
 * Copyright (c) 2016, 上海非码网络科技有限公司
 * All rights reserved.
 *
 */
#ifndef FMP_BASE_I_H
#define FMP_BASE_I_H

#include "../common/fmp_constants.h"
#include "../common/fmp_types.h"
#include "../common/fmp_events.h"

class ctkPluginContext;

class FMPBaseInterface
{
public:
    /**
      * 启动插件服务，同一模块只需要初始化一次就可。
      * \return 成功返回 \link FMP_SUCCESS \endlink。
      *         失败返回 \link FMP_FAILURE \endlink。
      *                       FMP_REFUSED
      */
    virtual int     StartService() = 0;

    /**
     * 停止插件服务
     * @brief StopService
     * @return
     */
    virtual int     StopService() = 0;

    /**
     * 获取插件服务
     * @brief GetService
     * @param ctx 插件环境
     * @return
     */
    template <class T>
    T*              GetService(ctkPluginContext *ctx)
    {
        T* svc = 0;
        ctkServiceReference ref = ctx->getServiceReference<T>();
        if (ref) {
            svc = ctx->getService<T>(ref);
        }

        return svc;
    }

protected:
    /**
     * 异步发送插件事件
     * @brief PostEvent
     * @param topic 事件话题
     * @param props 话题参数
     * @return
     */
    virtual int     PostEvent(const QString &topic, const FMPProps &pps) = 0;
};

Q_DECLARE_INTERFACE(FMPBaseInterface, "com.fmp.base")


#endif // FMP_BASE_I_H
