:: Work with the git and version template file("version.h")
:: Parameter 1: Version file path(Absolute or relative, must be in format <path>\$(ProjectName)\<version file>)
:: Parameter 2: Project name
@echo off

:: 0. Preparation
set company_name=ϺƼ޹˾
set vendor=Freemud
set file_desc=%2
set "file_desc=%file_desc:_=.%"
set project_name=%file_desc%
set src_res_name=pluginrc

set year=%date:~0,4%
set year=%year:/=-%
set /a year=%year%
set /a n=2000
if "%year%" LSS "%n%" set /a year=20%date:~0,2% 
set copy_right=Freemud Ltd. Copyright (C) 2014-%year%

:: 1. Catenate the version file path
set version_file=%~dpnx1
set version_file=%version_file:/=\%

:: 2. Increase the build number and generates in template file
:: echo //! This file is generated by a script, do NOT modify. %DATE:~0, 10% %TIME%> %version_file%
if "%2" equ "" (
  cd /d %~dp0%1
) else (
  cd /d %~dp0%2
)

for /f %%i in ('git describe') do set ver_tag=%%i

for /f "tokens=1 delims=-" %%i in ("%ver_tag%") do (
  set ver_tag=%%i
)

set tmp_ver=%ver_tag%

if "%tmp_ver%" neq "" set ver_tag=%tmp_ver%

for /f "tokens=1-3 delims=." %%h in ("%ver_tag%") do (
  set ver_maj=%%h
  set ver_min=%%i
  set ver_rev=%%j
)

for /f %%i in ('git rev-list HEAD --count') do set ver_build=%%i

set version=%ver_maj%.%ver_min%.%ver_rev%
echo %version%

if "%2" equ "" goto :EOF

:: 3. Generate version file
echo.#ifndef _VERSION_H_> "%version_file%"
echo.#define _VERSION_H_>> "%version_file%"
echo.>> "%version_file%"
echo.#define VER_MAJOR ^%ver_maj%>> "%version_file%"
echo.#define VER_MINOR ^%ver_min%>> "%version_file%"
echo.#define VER_REVISION ^%ver_rev%>> "%version_file%"
echo.>> "%version_file%"
echo.#define VER_BUILD ^%ver_build%>> "%version_file%"
echo.>> "%version_file%"
echo.//! Convert version numbers to string>> "%version_file%"
echo.#define _STR(S)  #S>> "%version_file%"
echo.#define STR(S) _STR(S)>> "%version_file%"
echo.>> "%version_file%"
echo.#define _MAK_VER(maj, min, rev, build) STR(##maj.##min.##rev.##build\0)>> "%version_file%"
echo.#define MAK_VER(maj, min, rev, build)  _MAK_VER(maj, min, rev, build)>> "%version_file%"
echo.>> "%version_file%"
echo.//! Resource version infomation>> "%version_file%"
echo.#define  RES_FILE_VER         VER_MAJOR,VER_MINOR,VER_REVISION,VER_BUILD>> "%version_file%"
echo.#define  RES_PRODUCT_VER      VER_MAJOR,VER_MINOR,VER_REVISION,VER_BUILD>> "%version_file%"
echo.#define  RES_STR_FILE_VER     MAK_VER(VER_MAJOR, VER_MINOR, VER_REVISION, VER_BUILD)>> "%version_file%"
echo.#define  RES_STR_PRODUCT_VER  MAK_VER(VER_MAJOR, VER_MINOR, VER_REVISION, VER_BUILD)>> "%version_file%"
echo.#define  RES_COMPANY_NAME     "%company_name%\0">> "%version_file%"
echo.#define  RES_COPYRIGHT        "%copy_right%\0">> "%version_file%"
echo.#define  RES_FILE_DESC        "%project_name%\0">> "%version_file%"
echo.#define  RES_INTER_NAME       "%project_name%\0">> "%version_file%"
echo.#define  RES_FILE_NAME        "%project_name%\0">> "%version_file%"
echo.#define  RES_PRODUCT_NAME     "%project_name%\0">> "%version_file%"
echo.#define  RES_FILE_EXT         "*\0">> "%version_file%"
echo.>> "%version_file%"
echo.#endif //!_VERSION_H_>> "%version_file%"


:: 4. Catenate project target name with version number

if NOT EXIST "%~dp0%2\res" mkdir "%~dp0%2\res"
set qrc_file=%~dp0%2\res\%2.qrc
set manifest=%~dp0%2\res\MANIFEST.MF
set qrc_temp=%qrc_file%.tmp

:: 5. Update manifest segament in project qrc file
:: Only do the following task when the version is actually changed
if NOT EXIST %qrc_file% (
  echo.^<RCC^>>%qrc_file%
  echo.    ^<qresource prefix="/%project_name%/META-INF"^>>>%qrc_file%
  echo.        ^<file^>MANIFEST.MF^</file^>>>%qrc_file%
  echo.    ^</qresource^>>>%qrc_file%
  echo.^</RCC^>>>%qrc_file%
) else (
  copy /y %qrc_file% %qrc_temp% 
  for /f "tokens=1* delims=:" %%h in ('findstr /n .* %qrc_temp%') do (
    if %%h equ 1 (
      echo %%i> %qrc_file%
    ) else (
      if "%%i" equ "" (
        echo.>> %qrc_file%
      ) else (
        if "%%i" equ " " (
          echo.>> %qrc_file%
        ) else (
          setlocal enabledelayedexpansion
          set EXIST_MF=false
          echo "%%i"|find "META-INF">nul&& set EXIST_MF=true
          if !EXIST_MF! equ true (
            echo ^<qresource prefix="/%project_name%/META-INF"^>>> %qrc_file%
          ) else (
            echo %%i>> %qrc_file%
          )
          endlocal
        )
      )
    )
  )

  del /q %qrc_temp%
)

:: 6. Generate CTK plugin manifest
echo.Plugin-SymbolicName: %project_name%>%manifest%
echo.Plugin-Version: %version%>>%manifest%
echo.Plugin-Name: %project_name%>>%manifest%
echo.Plugin-Copyright: %copy_right%>>%manifest%
echo.Plugin-Vendor: %vendor%>>%manifest%

:: 7. Generate resource file
copy /y %~dp0%src_res_name%.h %~dp0%2\res\resource.h
copy /y %~dp0%src_res_name%.rc %~dp0%2\res\%2.rc
