/*=============================================================================

  Library: CTK

  Copyright (c) German Cancer Research Center,
    Division of Medical and Biological Informatics

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

=============================================================================*/


#include "fmp_synchronizer_plugin_p.h"

#include "fmp_synchronizer.h"

#include <QtPlugin>
#include <QStringList>
#include <QDebug>

FMPSyncPlugin::FMPSyncPlugin()
  : _sync_service(0)
{
}

void FMPSyncPlugin::start(ctkPluginContext* context)
{
  _sync_service = new FMPSynchronizer(context);
  context->registerService(QStringList("FMPSyncInterface"), _sync_service);
}

void FMPSyncPlugin::stop(ctkPluginContext* context)
{
  Q_UNUSED(context)
  if (_sync_service)
  {
    delete _sync_service;
    _sync_service = 0;
  }
}

#if (QT_VERSION < QT_VERSION_CHECK(5,0,0))
Q_EXPORT_PLUGIN2(fmp_synchronizer, FMPSyncPlugin)
#endif
