#ifndef FMP_SYNCER_H
#define FMP_SYNCER_H

#include <QObject>
#include "fmp_syncer_i.h"

class ctkPluginContext;
class FMPSyncerPrivate;

class FMPSyncer : public QObject, public FMPSyncerInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPSyncerInterface)
    Q_DECLARE_PRIVATE(FMPSyncer)

public:
    explicit            FMPSyncer(ctkPluginContext *ctx);

    //! BaseInterface
    int                 StartService() { return FMP_SUCCESS; }
    int                 StopService() { return FMP_SUCCESS; }
protected:
    int                 PostEvent(const QString &topic, const FMPProps &pps = FMPProps());
public:
    //! SyncInterface
    void                Sync() {}


private:
    FMPSyncerPrivate *d_ptr;
};

#endif // FMP_SYNCER_H
