﻿#ifndef FMP_SETTINGS_I_H
#define FMP_SETTINGS_I_H

#include <QVariant>
#include <fmp_plugin_i.h>
#include "fmp_settings_def.h"

/**
 * 非业务插件，必须继承自 BaseInterface
 * @brief The FMPSettingsInterface class
 */
class FMPSettingsInterface : public FMPBaseInterface
{
public:
    virtual QVariant    GetValue(const QString& k) = 0;
    virtual bool        SetValue(const QString&k, QVariant v) = 0;


    bool                GetBool(const QString& k) { return GetValue(k).toBool(); }
    int                 GetInt(const QString& k) { return GetValue(k).toInt(); }
    uint                GetUInt(const QString& k) { return GetValue(k).toUInt(); }
    qint64              GetLong(const QString& k) { return GetValue(k).toLongLong(); }
    quint64             GetULongLong(const QString& k) { return GetValue(k).toULongLong(); }

    QByteArray          GetBytes(const QString& k) { return GetValue(k).toByteArray(); }
    QString             GetString(const QString& k) { return GetValue(k).toString(); }
};

Q_DECLARE_INTERFACE(FMPSettingsInterface, "com.fmp.settings")

#endif // FMP_SETTINGS_I_H
