﻿#ifndef FMP_SETTINGS_H
#define FMP_SETTINGS_H

#include "fmp_settings_i.h"

class ctkPluginContext;
class FMPSettingsPrivate;

/**
 * @brief The FMPSettings class
 */
class FMPSettings : public QObject, public FMPSettingsInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPSettingsInterface)
    Q_DECLARE_PRIVATE(FMPSettings)

public:
    explicit            FMPSettings(ctkPluginContext *context);

    //! BaseInterface
    int                 StartService();
    int                 StopService();
protected:
    int                 PostEvent(const QString &topic, const FMPProps &pps = FMPProps());

    //! SettingsInterface
public:
    QVariant            GetValue(const QString &k);
    bool                SetValue(const QString&k, QVariant v);

private:
    FMPSettingsPrivate *d_ptr;
};


class QSettings;
/**
 * @brief The FMPSettingsPrivate class
 */
class FMPSettingsPrivate
{
    Q_DECLARE_PUBLIC(FMPSettings)
public:
    explicit            FMPSettingsPrivate(ctkPluginContext *ctx);

    int                 DoStartService();
    int                 DoStopService();
    QVariant            GetValue(const QString &k);
    bool                SetValue(const QString&k, QVariant v);

public:
    FMPSettings        *q_ptr;
    ctkPluginContext   *_ctx;
    QSettings          *_sets;
};

#endif // FMP_SETTINGS_H
