#ifndef _VERSION_H_
#define _VERSION_H_

#define VER_MAJOR 0
#define VER_MINOR 1
#define VER_REVISION 0

#define VER_BUILD 10

//! Convert version numbers to string
#define _STR(S)  #S
#define STR(S) _STR(S)

#define _MAK_VER(maj, min, rev, build) STR(##maj.##min.##rev.##build\0)
#define MAK_VER(maj, min, rev, build)  _MAK_VER(maj, min, rev, build)

//! Resource version infomation
#define  RES_FILE_VER         VER_MAJOR,VER_MINOR,VER_REVISION,VER_BUILD
#define  RES_PRODUCT_VER      VER_MAJOR,VER_MINOR,VER_REVISION,VER_BUILD
#define  RES_STR_FILE_VER     MAK_VER(VER_MAJOR, VER_MINOR, VER_REVISION, VER_BUILD)
#define  RES_STR_PRODUCT_VER  MAK_VER(VER_MAJOR, VER_MINOR, VER_REVISION, VER_BUILD)
#define  RES_COMPANY_NAME     "ϺƼ޹˾\0"
#define  RES_COPYRIGHT        "Freemud Ltd. Copyright (C) 2014-2017\0"
#define  RES_FILE_DESC        "fmp.manager\0"
#define  RES_INTER_NAME       "fmp.manager\0"
#define  RES_FILE_NAME        "fmp.manager\0"
#define  RES_PRODUCT_NAME     "fmp.manager\0"
#define  RES_FILE_EXT         "*\0"

#endif //!_VERSION_H_
