﻿#ifndef FMP_MANAGER_EVENT_HANDLERS_H
#define FMP_MANAGER_EVENT_HANDLERS_H

#include <QObject>
#include <service/event/ctkEventConstants.h>
#include <service/event/ctkEventHandler.h>

class FMPluginManager;

/**
 * 管理器事件处理基类
 * @brief The FMPManagerEventHandler class
 */
class FMPManagerEventHandler : public ctkEventHandler
{
public:
    explicit            FMPManagerEventHandler(const QString &topic, FMPluginManager *pm) : _pm(pm), _topic(topic) {}

protected:
    FMPluginManager*    _pm;
    const QString       _topic;
};

/**
 * 升级事件处理类
 * @brief The FMPUpgradeEventHandler class
 */
class FMPUpgradeEventHandler : public QObject, public FMPManagerEventHandler
{
    Q_OBJECT
    Q_INTERFACES(ctkEventHandler)
public:
    explicit            FMPUpgradeEventHandler(ctkPluginContext *ctx, FMPluginManager *pm);
    void                handleEvent(const ctkEvent &event);

private:
    ctkPluginContext*   _ctx;
};

#endif // FMP_MANAGER_EVENT_HANDLERS_H
