﻿#include <fmp_logger_i.h>
#include "fmp_me_handlers.h"
#include "fmp_manager.h"

FMPUpgradeEventHandler::FMPUpgradeEventHandler(ctkPluginContext *ctx, FMPluginManager *pm)
    : FMPManagerEventHandler(FMP_TOPICS_SERVICES FMPE_SERVICE_REQ_UPDATE, pm),
      _ctx(ctx)
{
    FMPProps props;
    props[ctkEventConstants::EVENT_TOPIC] = _topic;
    _ctx->registerService<ctkEventHandler>(this, props);
}


void FMPUpgradeEventHandler::handleEvent(const ctkEvent &event)
{
    if (_pm) {
        if (event.getProperty(FMP_PROPKEY_AGREED).toBool()) {
            _pm->UpgradeOldPlugins(event.getProperty(FMP_PROPKEY_PID_LIST).toList());
        }
    }
    else {
        FMP_DEBUG_CTX(_ctx) << "No handler instance for event" << event.getTopic();
    }
}
