﻿#ifndef FMP_MANAGER_I_H
#define FMP_MANAGER_I_H

#include <fmp_base_i.h>

/**
 * 非业务插件接口，必须继承自 BaseInterface
 * @brief The FMPManagerInterface class
 */
class FMPManagerInterface : public FMPBaseInterface
{
public:
    /**
     * 加载插件目录下的所有新插件
     * 首次运行时，所有插件都视为新插件
     * @brief LoadNewPlugins
     * @return
     */
    virtual void    LoadNewPlugins() = 0;

    /**
     * 加载并启动插件 install, start
     * 插件生命周期开始，使用插件注册的服务前，还需要调用 StartService
     * @brief LoadPlugin
     * @param plugin 插件名称
     * @return
     */
    virtual int     LoadPlugin(const QString &plugin) = 0;

    /**
     * 请求更新旧版本插件
     * @brief UpgradeOldPlugins
     * @param pids
     * @return
     */
    virtual void    UpgradeOldPlugins(const QVariantList &pids) = 0;

    /**
     * 升级指定的插件
     * @brief UpdatePlugin
     * @param pid 插件ID
     * @return
     */
    virtual int     UpgradePlugin(long pid) = 0;

    /**
     * 设置插件参数
     * @brief SetProperties
     * @param props Key-Value
     * @return
     */
    virtual int     SetProperties(const FMPProps &props) = 0;
};

Q_DECLARE_INTERFACE(FMPManagerInterface, "fmp.manager")

#endif // FMP_MANAGER_I_H
