﻿#ifndef FMPLUGINMANAGER_H
#define FMPLUGINMANAGER_H

#include <QObject>
#include <QFileSystemWatcher>
#include "fmp_manager_i.h"
#include <ctkPluginEvent.h>
#include <ctkServiceEvent.h>
#include <ctkPluginFrameworkEvent.h>
#include <ctkPluginFrameworkFactory.h>

class FMPLoggerInterface;
class FMPSettingsInterface;
class FMPSyncerInterface;
class FMPEventHandler;

class FMPluginManager : public QObject, FMPManagerInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPManagerInterface)

#if (QT_VERSION > QT_VERSION_CHECK(5,0,0))
  Q_PLUGIN_METADATA(IID "com_fmp_manager")
#endif

public:
    explicit        FMPluginManager();
    ~FMPluginManager();

    //! 基础接口
    int             StartService();
    int             StopService();
    int             SetProperties(const FMPProps &props);
protected:
    int             PostEvent(const QString &topic, const FMPProps &pps = FMPProps());

public:
    //! 管理器接口
    void            LoadNewPlugins();
    int             LoadPlugin(const QString &plugin);
    void            UpgradeOldPlugins(const QVariantList &);
    int             UpgradePlugin(long pid);


public slots:
    void            OnPluginsChanged(const QString &path);

protected:
    QString         GetPluginPath(const QString &plugin_name, const QString &ver = QString());
    QStringList     GetNewPlugins();
    QVariantList    GetExpiredPlugins();


private slots:
    void            OnFrameworkEvent(const ctkPluginFrameworkEvent& event);
    void            OnPluginEvent(const ctkPluginEvent& event);
    void            OnServiceEvent(const ctkServiceEvent& event);

private:
    QSharedPointer<ctkPluginFramework>  _fw;
    ctkPluginFrameworkFactory          *_fw_factory;
    ctkProperties                       _fw_props;
    ctkPluginContext                   *_ctx;
    QFileSystemWatcher                  _watcher;

    FMPLoggerInterface                 *_logger;
    FMPSettingsInterface               *_setting;
    FMPSyncerInterface                 *_syncer;

    friend class    FMPEventHandler;
};

#endif // FMPLUGINMANAGER_H
