/*=============================================================================

  Library: CTK

  Copyright (c) German Cancer Research Center,
    Division of Medical and Biological Informatics

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

=============================================================================*/


#include "fmp_logger_plugin_p.h"

#include "fmp_logger.h"

#include <QtPlugin>
#include <QStringList>
#include <QDebug>

FMPLoggerPlugin::FMPLoggerPlugin()
  : _log_service(0)
{
}

void FMPLoggerPlugin::start(ctkPluginContext* context)
{
  _log_service = new FMPLogger(context);
  context->registerService<FMPLoggerInterface>(_log_service);
}

void FMPLoggerPlugin::stop(ctkPluginContext* context)
{
  Q_UNUSED(context)
  if (_log_service)
  {
    delete _log_service;
    _log_service = 0;
  }
}

#if (QT_VERSION < QT_VERSION_CHECK(5,0,0))
Q_EXPORT_PLUGIN2(fmp_logger, FMPLoggerPlugin)
#endif
