#ifndef FMP_LOGGER_P_H
#define FMP_LOGGER_P_H

#include "fmp_logger.h"

class FMPLoggerPrivate
{
    Q_DECLARE_PUBLIC(FMPLogger)
public:
    explicit            FMPLoggerPrivate(FMPLogger *q, ctkPluginContext *ctx);
    int                 Init();
    int                 Uninit();
    short               GetLogLevel();
    void                SetLogLevel(short level);
    uint                GetMaxLogSize();
    void                SetMaxLogSize(uint sz);
    QString             GetLogPath();
    void                SetLogPath(const QString &path);
    void                Log(short level, const QString &msg, const char* file, const char* func, int line);

protected:
    QString             _NewFileName();
    bool                _SetValue(const QString &key, QVariant v);
    QVariant            _GetValue(const QString &key, QVariant default_val = 0);

    void                _KeepFileSize();

public:
    bool                    _inited;
    FMPLogger              *q_ptr;
    ctkPluginContext       *_ctx;
    QMap<short, QString>    _lvlmap;
};

#define  _FMP_INFO     FMPNullLogStream(FMPLogger::LOG_INFO, __FILE__, __FUNCTION__, __LINE__)

#endif // FMP_LOGGER_P_H
