﻿#ifndef MENUBUTTON_H
#define MENUBUTTON_H
#include <QPushButton>
#include <QMouseEvent>

class MenuButton : public QPushButton
{
    Q_OBJECT
public:
    explicit MenuButton(QWidget* parent = 0);

    void setMovedItem(QWidget *item);

protected:
    void mouseMoveEvent(QMouseEvent * e);
    void mousePressEvent(QMouseEvent * e);
    void mouseReleaseEvent(QMouseEvent * e);

private:
    bool _mouseMove;
    bool _mousePress;
    bool _canMove;
    QPoint _lastMousePos;

    QWidget* _movedItem;
};

#endif // MENUBUTTON_H
