﻿#include "fmp_wnd.h"

#include <QDesktopWidget>
#include <QStyleOption>
#include <QPainter>
#ifdef Q_OS_WIN
#include <windows.h>
#include <windowsx.h>
#endif

FMPWnd::FMPWnd(QDialog *parent)
    : QDialog(parent)
{
    setWindowFlags(Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint);
    setAttribute(Qt::WA_TranslucentBackground);
}

FMPWnd::~FMPWnd()
{

}

int FMPWnd::exec()
{
    showFullScreen();
//    ::SetForegroundWindow((HWND)effectiveWinId());

//    ::SetWindowPos( (HWND)effectiveWinId(), HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);

//    showFullScreen();
//    ::SetForegroundWindow((HWND)effectiveWinId());

    QDesktopWidget w;
    QRect rc = w.availableGeometry();
    setGeometry((rc.width()-width())/2, (rc.height()-height())/2, width(), height());

    return QDialog::exec();
}

void FMPWnd::on_close_btn_clicked()
{
    this->done(-1);
}

#ifdef Q_OS_WIN
//! Gui class member of platform
bool FMPWnd::nativeEvent(const QByteArray &eventType, void *message, long *result)
{
    Q_UNUSED(eventType)
    MSG* msg = (MSG*)message;
    //! true indicates the message need to be processed by DefWindowProc
    bool fCallDWP = true;
    bool fMsgDone = false;
    switch (msg->message) {
    case WM_NCHITTEST: {
        *result = winHCHitTest(msg);
        if(*result != HTNOWHERE) {
            // HTMINBUTTON 等消息当作HTCLIENT处理
            switch (*result) {
            case HTMINBUTTON:
            case HTMAXBUTTON:
            case HTCLOSE:
                *result = HTCLIENT;
                break;
            }
            fCallDWP = false;
        }
        break;
    }
    case WM_GETMINMAXINFO: {
        // 最大化时的处理
        MINMAXINFO *mmi = (MINMAXINFO*)(msg->lParam);
        QDesktopWidget desktopWidget;
        QRect desktop = desktopWidget.availableGeometry();

        mmi->ptMaxSize.x = desktop.width();
        mmi->ptMaxSize.y = desktop.height();

        mmi->ptMaxPosition.x = desktop.x();
        mmi->ptMaxPosition.y = desktop.y();

        mmi->ptMinTrackSize.x = minimumWidth(); // mininum width for your window
        mmi->ptMinTrackSize.y = minimumHeight();

        mmi->ptMaxTrackSize.x = maximumWidth();
        mmi->ptMaxTrackSize.y = maximumHeight();

        *result = 0;
        fMsgDone = true;
        break;
    }
    case WA_INACTIVE: {
        activateWindow();
        break;
    }
    default:
        break;
    }
    fMsgDone = fMsgDone || !fCallDWP;
    return fMsgDone;
}

void FMPWnd::paintEvent(QPaintEvent *event)
{
    Q_UNUSED(event);
    QStyleOption opt;
    opt.init(this);
    QPainter p(this);
    style()->drawPrimitive(QStyle::PE_Widget, &opt, &p, this);
}

long FMPWnd::winHCHitTest(MSG *msg)
{
    // Mouse position
    QPoint mouse_pos(GET_X_LPARAM(msg->lParam), GET_Y_LPARAM(msg->lParam));
    QRect window_rect = geometry();

    // Set default value (HTNOWHERE) (1,1).
    USHORT uRow = 1;
    USHORT uCol = 1;
    bool fOnResizeBorder = false;

//    //! Test caption area
//    QRegion m_children_region(0, 0, width()-54, 60);
//    QRegion new_region = m_children_region.translated(window_rect.x(), window_rect.y());
//    if (new_region.contains(mouse_pos)) {
//        //! Title regions contains the mouse position, treat it as caption area
//        uRow = 0;
//    }

    // Hit test (HTTOPLEFT, ... HTBOTTOMRIGHT)
    LRESULT hitTests[3][3] =
    {
        {HTTOPLEFT, fOnResizeBorder ? HTTOP : HTCAPTION, HTTOPRIGHT},
        {HTLEFT, HTNOWHERE, HTRIGHT},
        {HTBOTTOMLEFT, HTBOTTOM, HTBOTTOMRIGHT},
    };

    //! Test borders area
    if (minimumSize() != maximumSize()) {
        //! To be implemented
    }

    return hitTests[uRow][uCol];
}
#endif
