﻿#ifndef FMNUMPAD_H
#define FMNUMPAD_H

#include "fmp_wnd.h"

class QLineEdit;

namespace Ui {
class FMNumPad;
}

class FMNumPad : public FMPWnd
{
    Q_OBJECT

public:
    explicit FMNumPad(QDialog *parent = 0);
    ~FMNumPad();

    void setLineEdit(QLineEdit* lineEdit);
signals:
    void digit_click(QString keynum);
    void digit_delete();
    void digit_clear();
    void digit_confirm();

private slots:
    void on_digit_clicked();

    void on_backspace_btn_clicked();

    void on_clear_btn_clicked();

    void on_confirm_btn_clicked();

private:
    Ui::FMNumPad *ui;

    QLineEdit       *_lineEdit;
};

#endif // FMNUMPAD_H
