﻿#include "fmp_num_pad.h"
#include "ui_fmnumpad.h"
#include <QLineEdit>

FMNumPad::FMNumPad(QDialog *parent) :
    FMPWnd(parent),
    ui(new Ui::FMNumPad),
    _lineEdit(nullptr)
{
    ui->setupUi(this);
    connect(ui->no0, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no1, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no2, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no3, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no4, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no5, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no6, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no7, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no8, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->no9, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
    connect(ui->dot, &QPushButton::clicked, this, &FMNumPad::on_digit_clicked);
}

FMNumPad::~FMNumPad()
{
    delete ui;
    if(_lineEdit) {
        delete _lineEdit;
        _lineEdit = nullptr;
    }
}

void FMNumPad::on_digit_clicked()
{
    QString num_str = qobject_cast<QPushButton*>(sender())->text();
    if(_lineEdit) {
        _lineEdit->insert(num_str);
        _lineEdit->setFocus();
    }
    emit digit_click(num_str);
}

void FMNumPad::on_backspace_btn_clicked()
{
    if(_lineEdit) {
        _lineEdit->backspace();
        _lineEdit->setFocus();
    }
    emit digit_delete();
}

void FMNumPad::on_clear_btn_clicked()
{
    if(_lineEdit) {
        _lineEdit->clear();
        _lineEdit->setFocus();
    }
    emit digit_clear();
}

void FMNumPad::on_confirm_btn_clicked()
{
    emit digit_confirm();
}

void FMNumPad::setLineEdit(QLineEdit *lineEdit)
{
    Q_ASSERT(nullptr != lineEdit);
    this->_lineEdit = lineEdit;
}
