﻿#ifndef FMP_LOGIN_H
#define FMP_LOGIN_H

#include "fmp_wnd.h"

class FMNumPad;

namespace Ui {
class FMPLogin;
}

class FMPLogin : public FMPWnd
{
    Q_OBJECT

public:
    explicit FMPLogin(QString url, QString storeId, QString partnerId, QDialog *parent = 0);
    ~FMPLogin();

    /**
     * @brief login
     * @param userName
     * @param password
     * @return
     */
    bool            login(QString userName, QString password);
    bool            isLogined() {return _userName != "";}
    QString         userName() {return _userName;}
    QString         errorMsg() {return _errorMsg;}

private slots:
    void on_login_btn_clicked();

    void on_key_btn_clicked();

    void on_key_btn_2_clicked();

private:
    Ui::FMPLogin *ui;

    FMNumPad*       _numPad;
    QString         _userName;
    QString         _errorMsg;

    const QString   _url;
    const QString   _storeId;
    const QString   _partnerId;
};

#endif // FMP_LOGIN_H
