﻿#include "fmp_home_plugin_p.h"

#include "fmp_home.h"

#include <QtPlugin>

FMPHomePlugin::FMPHomePlugin()
    :_home_service(0)
{
}

void FMPHomePlugin::start(ctkPluginContext *context)
{
    _home_service = new FMPHome(context);
    context->registerService<FMPHomeInterface>(_home_service);
}

void FMPHomePlugin::stop(ctkPluginContext *context)
{
    Q_UNUSED(context)
    if (_home_service)
    {
        delete _home_service;
        _home_service = 0;
    }
}

#if (QT_VERSION < QT_VERSION_CHECK(5,0,0))
Q_EXPORT_PLUGIN2(fmp_home, FMPHomePlugin)
#endif
