﻿#ifndef FMP_HOME_P_H
#define FMP_HOME_P_H

#include "fmp_home.h"

class NavWindow;
class FMPLogin;
class FMPSettingsInterface;

class FMPHomePrivate : public QObject
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(FMPHome)
public:
    explicit        FMPHomePrivate(FMPHome *q);
                    ~FMPHomePrivate();
    int             Init();
    int             Uninit();

    void            StartPlugins(const QVariantList &pids);
    int             login();

public slots:
    void            onMenuBtnClicked(QString btnName);

public:
    FMPHome         *q_ptr;

    bool            _isLogined;
    QString         _userName;
    QString         _errorMsg;

private:
    NavWindow       *_navWindow;
    FMPSettingsInterface    *_settings;
};

#endif // FMP_HOME_P_H
