﻿#ifndef NAVWINDOW_H
#define NAVWINDOW_H

#include <QDialog>
#include <vector>
#include <QString>

namespace Ui {
class NavWindow;
}

class QButtonGroup;
class QAbstractButton;
class QParallelAnimationGroup;
class FMPSettingsInterface;

class NavWindow : public QDialog
{
    Q_OBJECT

public:
    /**
     * @brief The NavStatus enum
     * Default: 默认状态
     * Message: 由新消息状态
     * Spread:  菜单按钮展开状态
     */
    enum NavStatus {
        Default = 0,
        Spread,
        Message
    };

    explicit NavWindow(FMPSettingsInterface* &settings, QWidget *parent = 0);
    ~NavWindow();

public slots:
    /**
     * @brief setNavStatus
     * 设置该导航窗口的状态
     * @param status
     */
    void setNavStatus(const NavStatus status);

    /**
     * @brief spreadMenus
     * 展开或关闭菜单按钮
     * @param isSpread
     */
    void spreadMenus(const bool isSpread);

signals:
    void menuBtnClicked(QString btnName);
    void statusChanged(NavStatus status);

private slots:
    void on_navMainBtn_clicked();
    void onMenuBtnClicked(QAbstractButton*);
    void onStatusChanged(NavStatus status);

private:
    Ui::NavWindow *ui;

    NavStatus _status;
    QButtonGroup* _btn_group;
    QParallelAnimationGroup* _animationShow;

    void initMenu();

private:
    std::vector<QString> btns;
    const double PI;
    struct MenuUiProps
    {
        int distance;
        double beginAngle;
        double endAngle;
    };
    MenuUiProps MenuUiProp;
    bool isUseAnimation;

    FMPSettingsInterface    *_settings;
};

#endif // NAVWINDOW_H
