﻿#include "fmp_home_navwindow.h"
#include "ui_fmp_home_navwindow.h"
#include "menubutton.h"
#include <QDebug>
#include <QDesktopWidget>
#include <QParallelAnimationGroup>
#include <QPropertyAnimation>
#include <fmp_settings_i.h>

NavWindow::NavWindow(FMPSettingsInterface *&settings, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::NavWindow),
    _btn_group(new QButtonGroup(this)),
    _animationShow(new QParallelAnimationGroup(this)),
    PI(3.1415926),
    _settings(settings)
{
    ui->setupUi(this);
    ui->navMainBtn->setMovedItem(this);

    btns.push_back("payment");
    btns.push_back("tool");
    MenuUiProp.distance = 100;
    MenuUiProp.beginAngle = -(PI*0.45);
    MenuUiProp.endAngle = (PI*0.45);
    isUseAnimation = _settings->GetBool(FMP_INIKEY_HOMEANIMATION);

    setNavStatus(Default);

    this->setAttribute(Qt::WA_TranslucentBackground);
    this->setWindowFlags(windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint | Qt::Tool);

    connect(_btn_group, SIGNAL(buttonClicked(QAbstractButton*)), this, SLOT(onMenuBtnClicked(QAbstractButton*)));
    initMenu();

    connect(this, SIGNAL(statusChanged(NavStatus)), this, SLOT(onStatusChanged(NavStatus)));
    connect(_animationShow, &QParallelAnimationGroup::finished, this, [=](){
        ui->navMainBtn->lower();
    });
}

NavWindow::~NavWindow()
{
    delete _btn_group;
    delete _animationShow;
    delete ui;
}

void NavWindow::setNavStatus(const NavStatus status)
{
    this->_status = status;
    emit statusChanged(status);
}

void NavWindow::on_navMainBtn_clicked()
{
    int status = this->_status;
    status = (status+1)%2;
    setNavStatus((NavStatus)status);
}

void NavWindow::spreadMenus(const bool isSpread)
{
    //! Start animation.
    if(isSpread && isUseAnimation) {
        ui->navMainBtn->raise();
        _animationShow->start();
    }
    //! Set the menu btns are visible.
    foreach (QAbstractButton *b , _btn_group->buttons()) {
        auto btn = qobject_cast<QPushButton*>(b);
        btn->setVisible(isSpread);
    }
}

void NavWindow::initMenu()
{
    int centerX = ui->navMainBtn->x() + ui->navMainBtn->width()/2;
    int centerY = ui->navMainBtn->y() + ui->navMainBtn->height()/2;

    const int dis = MenuUiProp.distance;
    int btnsNum = btns.size();
    double jianGe = 0;
    if(btnsNum > 1) {
        jianGe = (MenuUiProp.endAngle - MenuUiProp.beginAngle)/(btns.size()-1);
    }
    const int btnWidth = 60;

    for(decltype(btns.size()) i = 0; i<btns.size(); ++i) {
        auto btn = new QPushButton(this);
        btn->setVisible(false);

        double angle = MenuUiProp.beginAngle + jianGe*i;
        int x = centerX + dis*cos(angle) - btnWidth/2;
        int y = centerY + dis*sin(angle) - btnWidth/2;

        btn->setObjectName(btns[i]);
        btn->setGeometry(x, y, btnWidth, btnWidth);
        _btn_group->addButton(btn);

        // 创建动画
        auto animation = new QPropertyAnimation(btn, "geometry");
        animation->setDuration(200);
        animation->setStartValue(QRect(centerX-btn->width()/2,centerY-btn->width()/2,btn->width(),btn->height()));
        animation->setEndValue(btn->geometry());
        _animationShow->addAnimation(animation);
    }
}

void NavWindow::onMenuBtnClicked(QAbstractButton *btn)
{
    QString btnName = btn->objectName();
    emit menuBtnClicked(btnName);
}

void NavWindow::onStatusChanged(NavStatus status)
{
    switch (status) {
    case Default:
        spreadMenus(false);
        ui->navMainBtn->setStyleSheet("#navMainBtn{ border-image: url(:fm-icon_01)}");
        break;
    case Spread:
        spreadMenus(true);
        ui->navMainBtn->setStyleSheet("#navMainBtn{ border-image: url(:fm-icon_02)}");
        break;
    case Message:
        ui->navMainBtn->setStyleSheet("#navMainBtn{ border-image: url(:xiaoxi)}");
        break;
    default:
        ui->navMainBtn->setStyleSheet("#navMainBtn{ border-image: url(:fm-icon_01)}");
        break;
    }
}
