﻿#ifndef FMP_HOME_H
#define FMP_HOME_H

#include <QObject>

#include "fmp_home_i.h"

class ctkPluginContext;
class FMPHomePrivate;
class FMPStartEventHandler;

class FMPHome : public QObject, public FMPHomeInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPHomeInterface)
    Q_DECLARE_PRIVATE(FMPHome)
public:
    explicit            FMPHome(ctkPluginContext *context);
    ~FMPHome();

    int                 StartService();
    int                 StopService();

    void                StartPlugins(const QVariantList &pids);

    int                 login();
    bool                isLogined();
    QString             userName();

private:
    FMPHomePrivate      *d_ptr;
    bool                 _inited;

    friend class        FMPStartEventHandler;
};

#endif // FMP_HOME_H
