﻿#include "fmp_home_p.h"
#include <QVariant>
#include <ctkPluginContext.h>

FMPHome::FMPHome(ctkPluginContext *context)
    : FMPHomeInterface(context),
      d_ptr(new FMPHomePrivate(this)),
      _inited(false)
{
}

FMPHome::~FMPHome()
{
    delete d_ptr;
}

int FMPHome::StartService()
{
    if (_inited) return FMP_SUCCESS;
    Q_D(FMPHome);
    return d->Init();
}

int FMPHome::StopService()
{
    if (!_inited) return FMP_SUCCESS;
    Q_D(FMPHome);
    return d->Uninit();
}

void FMPHome::StartPlugins(const QVariantList &pids)
{
    Q_D(FMPHome);
    d->StartPlugins(pids);
}

int FMPHome::login()
{
    Q_D(FMPHome);
    return d->login();
}

bool FMPHome::isLogined()
{
    Q_D(FMPHome);
    return d->_isLogined;
}

QString FMPHome::userName()
{
    Q_D(FMPHome);
    return d->_userName;
}
