﻿#ifndef FMP_MANAGER_EVENT_HANDLERS_H
#define FMP_MANAGER_EVENT_HANDLERS_H

#include <QObject>
#include <service/event/ctkEventConstants.h>
#include <service/event/ctkEventHandler.h>

class FMPHome;

class FMPHomeEventHandler : public ctkEventHandler
{
public:
    explicit            FMPHomeEventHandler(const QString &topic, FMPHome *home) : _home(home), _topic(topic) {}

protected:
    FMPHome*            _home;
    const QString       _topic;
};

class FMPStartEventHandler : public QObject, public FMPHomeEventHandler
{
    Q_OBJECT
    Q_INTERFACES(ctkEventHandler)
public:
    explicit            FMPStartEventHandler(ctkPluginContext *ctx, FMPHome *home);
    void                handleEvent(const ctkEvent &event);

private:
    ctkPluginContext*   _ctx;
};

#endif // FMP_MANAGER_EVENT_HANDLERS_H
