﻿#include <fmp_logger_i.h>
#include "fmp_he_handlers.h"
#include "fmp_home.h"

FMPStartEventHandler::FMPStartEventHandler(ctkPluginContext *ctx, FMPHome *home)
    : FMPHomeEventHandler(FMP_TOPICS_SERVICES FMPE_SERVICE_REQ_START "/*" , home),
      _ctx(ctx)
{
    FMPProps props;
    props[ctkEventConstants::EVENT_TOPIC] = _topic;
    _ctx->registerService<ctkEventHandler>(this, props);
}


void FMPStartEventHandler::handleEvent(const ctkEvent &event)
{
    qDebug() << "===========";
    if (_home) {
        QString ack_topic = event.getTopic();
        //! com/fmp/services/REQ_START/id
        ack_topic.replace(FMPE_SERVICE_REQ_START, FMPE_SERVICE_ACK_START);
        FMPProps props;
        props[FMP_PROPKEY_AGREED] = _home->isLogined();
        _home->PostEvent(ack_topic, props);
    }
    else {
        FMP_DEBUG_CTX(_ctx) << "No handler instance for event" << event.getTopic();
    }
}
