﻿#ifndef FMNETWORK_H
#define FMNETWORK_H

#include <QObject>

class QNetworkAccessManager;
class QNetworkRequest;

class FMNetwork : public QObject
{
    Q_OBJECT
public:
    explicit FMNetwork(QObject *parent = 0);
    ~FMNetwork();

    /**
     * @brief post
     * @param url       请求地址
     * @param reqData   请求数据
     * @param rspData   返回数据
     * @return          是否有错误
     */
    bool        post(const QString &url, const QByteArray *reqData, QByteArray *rspData);

    QString     errorString() const { return _errorString;}
private:
    QNetworkAccessManager   *_nam;
    QNetworkRequest         *_req;
    QString                 _errorString;
};

#endif // FMNETWORK_H
