#ifndef WAITDIALOG_H
#define WAITDIALOG_H

#include <QDialog>
#include "mysock.h"
#include <windows.h>

#define HS_OK    0xF0
#define HS_ERROR 0xFF

class Dialog;

namespace Ui {
class WaitDialog;
}

class WaitDialog : public QDialog
{
    Q_OBJECT

public:
    explicit WaitDialog(QWidget *parent = 0);
    ~WaitDialog();

    static bool pay(const QJsonObject& in_json, QJsonObject &out_json, Dialog *parent = 0 );

    static bool refund(const QJsonObject &in_json, QJsonObject &out_json, Dialog *parent);

signals:
    void SuccessJson(const mySock::RequstType type, const QJsonObject& json);

private:
    void slReturnJson(const mySock::RequstType type, const QJsonObject& json);
    void slerror(int socketError, const QString &message);
    void delErrCode(const int code, QString msg = QString(""));
    void delBtn(bool isSuccess);

    void getOutJson( QJsonObject& json);
    Ui::WaitDialog *ui;

    QJsonObject outJson;

    //打印
    typedef int ( *initPrint)( void);
    typedef int ( *printText)( char *str, int fontSize);
    typedef int ( *BeginPrint)(void);
    typedef int ( *closePrinter)(void);

    bool printing(const QString& text);

    HMODULE dllHandle;

};

#endif // WAITDIALOG_H
