﻿#include "systray.h"

SysTray::SysTray(QObject *parent) : QSystemTrayIcon(parent)
{
    creatMenu();
    //image: url(:/login/res/16.ico);
    this->setIcon( QIcon(":/logo/sys"));

    connect(this , SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, SLOT(iconIsActived(QSystemTrayIcon::ActivationReason)));
}

void SysTray::creatMenu()
{
    QMenu *menu = new QMenu();

    QAction *openMian = new QAction(tr("显示主窗体"),menu);
    QAction *set = new QAction( tr("设置门店"), menu);
    QAction *quit = new QAction( tr("退出"),menu);

    connect( openMian, &QAction::triggered, this, &SysTray::sgOpenMainDialog);
    connect( set, &QAction::triggered, this, &SysTray::sgSet);
    connect( quit ,&QAction::triggered, this, &SysTray::sgExit);

    menu->addAction( openMian);
   // menu->addAction( set);
    menu->addSeparator();
    menu->addAction( quit);

    menu->setStyleSheet( "QMenu\
                        {\
                            font: 10pt \"新宋体\";\
                            color: rgb(0, 0, 0);\
                        }\
                        ");

    this->setContextMenu( menu);
}

void SysTray::iconIsActived(QSystemTrayIcon::ActivationReason reason)
{
    qDebug() << "iconIsActived";
    switch(reason)
    {      //点击托盘显示窗口
        case QSystemTrayIcon::Trigger:
            emit sgOpenMainDialog();
            break;
        case QSystemTrayIcon::DoubleClick:
            emit sgOpenMainDialog();
            break;
        default:
            break;
    }
}



