#include "numkeywidget.h"
#include "ui_numkeywidget.h"

numKeyWidget::numKeyWidget(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::numKeyWidget)
{
    ui->setupUi(this);
    connect( ui->btnKey_point, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_00, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_0, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_1, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_2, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_3, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_4, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_5, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_6, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_7, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_8, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);
    connect( ui->btnKey_9, &QPushButton::clicked, this, &numKeyWidget::btn_num_click);

    connect( ui->btn_ok, &QPushButton::clicked, this, &numKeyWidget::btn_ok_click);
    connect( ui->btn_cannel, &QPushButton::clicked, this, &numKeyWidget::btn_cannel_click);
    connect( ui->btn_backspace, &QPushButton::clicked, this, &numKeyWidget::btn_backspace_click);
    connect( ui->btn_clear, &QPushButton::clicked, this, &numKeyWidget::btn_clear_click);

    this->setWindowFlags(this->windowFlags() | Qt::WindowStaysOnTopHint);
}

numKeyWidget::~numKeyWidget()
{
    delete ui;
}

void numKeyWidget::btn_num_click()
{
    QPushButton *btn = (QPushButton *)sender();

    QString key = "0";

    if( btn == ui->btnKey_0)
        key = "0";
    if( btn == ui->btnKey_1)
        key = "1";
    if( btn == ui->btnKey_2)
        key = "2";
    if( btn == ui->btnKey_3)
        key = "3";
    if( btn == ui->btnKey_4)
        key = "4";
    if( btn == ui->btnKey_5)
        key = "5";
    if( btn == ui->btnKey_6)
        key = "6";
    if( btn == ui->btnKey_7)
        key = "7";
    if( btn == ui->btnKey_8)
        key = "8";
    if( btn == ui->btnKey_9)
        key = "9";
    if( btn == ui->btnKey_00)
        key = "00";
    if( btn == ui->btnKey_point)
        key = ".";


    QString value =  ui->lineEdit->text();
    QString tv = value.append( key);

    ui->lineEdit->setText(tv);

}

void numKeyWidget::btn_ok_click()
{
    this->accept();
}

void numKeyWidget::btn_cannel_click()
{

    this->reject();
}

void numKeyWidget::btn_clear_click()
{
    ui->lineEdit->clear();
}

void numKeyWidget::btn_backspace_click()
{
    QString value =  ui->lineEdit->text();
    value.chop(1);
    ui->lineEdit->setText( value);
}

int numKeyWidget::getAmount()
{
    QString v = ui->lineEdit->text();
    return v.toInt();
}

QString numKeyWidget::getInputNum()
{
    numKeyWidget v;
    v.raise();
    QString num ;
    if( v.exec() == QDialog::Accepted){
        num = v.ui->lineEdit->text();
    }
    return num;

}


