#ifndef MYSOCK_H
#define MYSOCK_H

#include <QObject>
#include <QTcpSocket>
#include <QThread>
#include <QWaitCondition>
#include <QMutexLocker>
#include <QJsonDocument>
#include <QJsonArray>
#include <QJsonObject>
#include <QApplication>

class mySock : public QThread
{
    Q_OBJECT
public:
    explicit mySock(QObject *parent = 0);

    typedef enum{
        Login,
        Query,
        Accpet,
        Reject,
        Consume
    }RequstType;

    void getNewJosn(const mySock::RequstType type,  const QJsonObject& json);

    void run() Q_DECL_OVERRIDE;

signals:
    void error(int socketError, const QString &message);
    void sgReturnJson(const mySock::RequstType type, const QJsonObject& json);
    void sgThreadBegin(const bool isBegin);  //数据线程已经工作，通知界面锁btn


public slots:

private:
    void threadQuitErr( int socketError, const QString &message);
    bool isFullJson( const QByteArray& array);
    QJsonObject getReturnJsonObject( const QByteArray& array);

    //
    QString hostName;
    quint16 port;
    //中间数据
    QByteArray sendArray;
    RequstType reType;
    //锁和信号
    QMutex mutex;
    QWaitCondition cond;

    bool quit;
//    char sendBuf[4096];
//    char receBuf[4096];
};

mySock * getMySock();

#endif // MYSOCK_H
