#include "lc_my_widget.h"
#include <QMouseEvent>
#include <QPoint>
#include <QPainter>
#include <QDebug>

LcMyWidget::LcMyWidget(QWidget *parent) :
    QDialog(parent)
{
    mouse_press = false;

    setWindowFlags(Qt::FramelessWindowHint);
    //透明
    //setWindowOpacity(1);
    // setAttribute(Qt::WA_TranslucentBackground);
}

void LcMyWidget::mousePressEvent(QMouseEvent *event)
{
    if (event->button() == Qt::LeftButton) {
        mouse_press = true;
        beginpoint=pos();
        move_point = event->globalPos() - pos();
    }
    //窗口移动距离
}

void LcMyWidget::mouseMoveEvent(QMouseEvent *event)
{
    //若鼠标左键被按下
    if(mouse_press)
    {
        //鼠标相对于屏幕的位置
        QPoint move_pos = event->globalPos();

        //移动主窗体位置
        this->move(move_pos - move_point);
    }
}

void LcMyWidget::mouseReleaseEvent(QMouseEvent *event)
{
    //设置鼠标为未被按下
    QPoint move_pos=event->globalPos()-move_point-beginpoint;
    int x=move_pos.x();
    int y=move_pos.y();
    if(-5<x&&x<5&&y<5&&-5<y)
    {
        emit sgBtnClick();
    }

    mouse_press = false;
}

//void LcMyWidget::paintEvent(QPaintEvent *event)
//{

//}






