#include "getcodedialog.h"
#include "ui_getcodedialog.h"

GetCodeDialog::GetCodeDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::GetCodeDialog)
{
    ui->setupUi(this);

    connect( ui->txtCode, &QLineEdit::returnPressed, this, &GetCodeDialog::accept);
    connect( ui->btnSure, &QPushButton::clicked, this, &GetCodeDialog::accept);
    connect( ui->btnCannel, &QPushButton::clicked, this, &GetCodeDialog::reject);
}

GetCodeDialog::~GetCodeDialog()
{
    delete ui;
}

bool GetCodeDialog::getCode(QString &out_code, QWidget *parent)
{
    GetCodeDialog v(parent);

    bool res = false;

    if( v.exec() == QDialog::Accepted){
        out_code = v.ui->txtCode->text();
        if( !out_code.isEmpty())
            res = true;
    }
    return res;
}
