﻿#ifndef FMP_MANAGER_EVENT_HANDLERS_H
#define FMP_MANAGER_EVENT_HANDLERS_H

#include <QObject>
#include <service/event/ctkEventConstants.h>
#include <service/event/ctkEventHandler.h>

class FMPePay;


class FMPePayEventHandler : public ctkEventHandler
{
public:
    explicit            FMPePayEventHandler(const QString &topic, FMPePay *epay) : _epay(epay), _topic(topic) {}

protected:
    FMPePay*            _epay;
    const QString       _topic;
};

/**
 * 升级事件处理类
 * @brief The FMPUpgradeEventHandler class
 */
class FMPStartEventHandler : public QObject, public FMPePayEventHandler
{
    Q_OBJECT
    Q_INTERFACES(ctkEventHandler)
public:
    explicit            FMPStartEventHandler(ctkPluginContext *ctx, FMPePay *epay);
    void                handleEvent(const ctkEvent &event);

private:
    ctkPluginContext*   _ctx;
};

#endif // FMP_MANAGER_EVENT_HANDLERS_H
