﻿#include <fmp_logger_i.h>
#include "fmp_pe_handlers.h"
#include "fmp_epay.h"

FMPStartEventHandler::FMPStartEventHandler(ctkPluginContext *ctx, FMPePay *epay)
    : FMPePayEventHandler(FMP_TOPICS_SERVICES FMPE_SERVICE_ACK_START "/"
                          + QString::number(ctx->getPlugin()->getPluginId()), epay),
      _ctx(ctx)
{
    FMPProps props;
    props[ctkEventConstants::EVENT_TOPIC] = _topic;
    _ctx->registerService<ctkEventHandler>(this, props);
}


void FMPStartEventHandler::handleEvent(const ctkEvent &event)
{
    if (_epay) {
        if (event.getProperty(FMP_PROPKEY_AGREED).toBool()) {
            _epay->Pay();
        }
        else {
            FMP_WARN_CTX(_ctx) << "Refused start request" << event.getTopic();
        }
    }
    else {
        FMP_DEBUG_CTX(_ctx) << "No handler instance for event" << event.getTopic();
    }
}
