﻿#include "fmp_epay_p.h"
#include <fmp_settings_i.h>
#include <QCoreApplication>
#include <QDateTime>
#include <ctkPluginContext.h>
#include <ctkServiceReference.h>
#include <QDebug>
#include "fmp_pe_handlers.h"
#include "Dialog.h"
#include "qfmclient.h"

FMPePayPrivate::FMPePayPrivate(QObject *parent)
    : QObject(parent),
      _fmClient(nullptr),
      _payDialog(nullptr)
{

}

//FMPePayPrivate::~FMPePayPrivate()
//{
//    if(_payDialog != nullptr) {
//        delete _payDialog;
//    }
//}

//int FMPePayPrivate::StartService()
//{
//    qDebug() << "======== ePay init ===========";
//    Q_Q(FMPePay);

//    q->_inited = true;
//    return FMP_SUCCESS;
//}

int FMPePayPrivate::StopService()
{
    Q_Q(FMPePay);

    //! Clean up
    q->_inited = false;
    return FMP_SUCCESS;
}

int FMPePayPrivate::Pay()
{
    connect(this, SIGNAL(showPayWnd()), this, SLOT(onShowPayWnd()));
    emit showPayWnd();
    return FMP_SUCCESS;
}

void FMPePayPrivate::onShowPayWnd()
{
    if(_payDialog == nullptr && _fmClient == nullptr) {
        _fmClient = new QFmClient();
        _fmClient->start();
        _payDialog = new Dialog();
        _payDialog->show();
    } else {
        delete _payDialog;
        _payDialog = new Dialog();
        _payDialog->show();
    }
}
