﻿#include "dialog.h"
#include "ui_dialog.h"
#include "getcodedialog.h"
#include "workutil.h"
#include "define.h"
#include "waitdialog.h"
#include "qfmclient.h"
#include <QPixmap>

Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)/*,
    israise(false)*/
{

    ui->setupUi(this);
    ui->label_7->setText(QDateTime::currentDateTime().toString("yyyy-MM-dd"));

    //folatWidget = new FolatWidget();
    curTxt = ui->txt_amount;
    //m_timer=new QTimer;
    //m_timer->setInterval(2000);
    //m_timer->start();
    //connect(m_timer,&QTimer::timeout,this,&Dialog::floatraise);
    connect(ui->no0, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no00, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no1, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no2, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no3, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no4, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no5, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no6, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no7, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no8, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->no9, &QPushButton::clicked, this, &Dialog::btn_num_click);
    connect(ui->dot, &QPushButton::clicked, this, &Dialog::btn_num_click);

    connect( ui->txt_amount, &LcMyLineEdit::focusIn, this, &Dialog::txtFcous);
    connect( ui->txt_paycode, &LcMyLineEdit::focusIn, this, &Dialog::txtFcous);

//    connect( &tray, &SysTray::sgOpenMainDialog, this, &Dialog::slopenMain);
//    connect( &tray, &SysTray::sgExit, this, &Dialog::slExit);

    //connect( folatWidget, &FolatWidget::sgBtnClick, this, &Dialog::initShow);
    QPixmap pixmap(":/res/fmclient-icon_payment_s1.png");
    ui->pushButton_2->setIcon(pixmap);
    ui->pushButton_2->setIconSize(pixmap.size());
    ui->pushButton_2->setFixedSize(159,68);
    QPixmap pixmap2(":/res/fmclient-icon_payment_t1.png");
    ui->pushButton_3->setIcon(pixmap2);
    ui->pushButton_3->setIconSize(pixmap2.size());
    ui->pushButton_3->setFixedSize(159,68);
    ui->pushButton_2->setChecked(true);
    ui->pushButton_4->hide();
    ui->txt_paycode->setFocus();
    setWindowFlags( windowFlags() | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);

    ui->stackedWidget->setCurrentIndex(0);
}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::onShow()
{
    this->show();
}

void Dialog::initShow()
{
    //israise=false;
    //folatWidget->hide();

    //folatWidget->setWindowFlags( folatWidget->windowFlags() | Qt::CustomizeWindowHint);
    setWindowFlags( windowFlags() | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);
    //this->move(0,0);
    this->setWindowFlags(Qt::FramelessWindowHint);
    this->show();
    this->raise();
    ui->txt_amount->setFocus();
}

void Dialog::folatShow()
{
    this->hide();
    //israise=true;
    //ui->txt_paycode->clear();
    ui->txt_paycode->setFocus();
    setWindowFlags( windowFlags() | Qt::CustomizeWindowHint);

    //folatWidget->setWindowFlags( folatWidget->windowFlags() | Qt::WindowStaysOnTopHint);

    //folatWidget->show();
    //folatWidget->raise();

    ui->stackedWidget->setCurrentIndex(0);
}

void Dialog::slopenMain()
{
//    if( this->isHidden())
//        folatWidget->show();

//    if( folatWidget->isHidden())
//        this->show();
}

void Dialog::slExit()
{
    exit(0);
}

void Dialog::keyPressEvent(QKeyEvent *e)
{
    if(e->key()==Qt::Key_Enter)
    {

    }
}

void Dialog::btn_num_click()
{
    QString num_str = qobject_cast<QPushButton*>(sender())->text();
    curTxt->setText(curTxt->text().append(num_str));
}

void Dialog::on_pushButton_2_clicked()
{
    QPixmap pixmap(":/res/fmclient-icon_payment_s1.png");
    ui->pushButton_2->setIcon(pixmap);
    ui->pushButton_2->setIconSize(pixmap.size());
    ui->pushButton_2->setFixedSize(159,68);
    QPixmap pixmap2(":/res/fmclient-icon_payment_t1.png");
    ui->pushButton_3->setIcon(pixmap2);
    ui->pushButton_3->setIconSize(pixmap2.size());
    ui->pushButton_3->setFixedSize(159,68);
    ui->pushButton_2->setChecked(true);
    ui->pushButton_3->setChecked(false);
    ui->label_8->setText("应付金额");
    ui->label_9->setText("付款条码");
    ui->txt_amount->setPlaceholderText("本次消费金额");
    ui->txt_amount->setFocus();
    ui->txt_amount->clear();
    ui->txt_paycode->clear();
}

void Dialog::on_pushButton_3_clicked()
{
    QPixmap pixmap(":/res/fmclient-icon_payment_s2.png");
    ui->pushButton_2->setIcon(pixmap);
    ui->pushButton_2->setIconSize(pixmap.size());
    ui->pushButton_2->setFixedSize(159,68);
    QPixmap pixmap2(":/res/fmclient-icon_payment_t2.png");
    ui->pushButton_3->setIcon(pixmap2);
    ui->pushButton_3->setIconSize(pixmap2.size());
    ui->pushButton_3->setFixedSize(159,68);
    ui->pushButton_3->setChecked(true);


    ui->pushButton_2->setChecked(false);
    ui->pushButton_3->setChecked(true);
    ui->label_8->setText("退款金额");
    ui->label_9->setText("交易序号");
    ui->txt_amount->setPlaceholderText("本次退款金额");
    ui->txt_amount->setFocus();
    ui->txt_amount->clear();
    ui->txt_paycode->clear();
}

void Dialog::on_noline_clicked()
{
    if(curTxt == ui->txt_amount)
        ui->txt_paycode->setFocus();
    else
        ui->txt_amount->setFocus();
}

void Dialog::on_nook_clicked()
{
//    if(ui->txt_amount->text() == "" ||
//            ui->txt_paycode->text() == "")
//    {
//        QMessageBox box;
//        box.setText("金额和条码不能为空!");

//        box.move(this->width()/2 - 120, this->height()/2 - 60);
//        box.exec();

//        return ;
//    }

    if(ui->pushButton_2->isChecked())
    {
        float aa = ui->txt_amount->text().toFloat();

        int amount = (int)( (aa + 0.005) * 100) ;

        QString code = ui->txt_paycode->text();
        QJsonObject in_json, out_json;
        getPayJson( in_json, code , amount);

        bool res = WaitDialog::pay(  in_json, out_json, this);

    }
    else
    {
        float aa = ui->txt_amount->text().toFloat();

        int amount = (int)( (aa + 0.005) * 100) ;

        QString code = ui->txt_paycode->text();
        QJsonObject in_json, out_json;
        getRefundJson( in_json, code , amount);

        bool res = WaitDialog::refund(in_json, out_json, this);

    }

}

void Dialog::getPayJson(QJsonObject &json, const QString &code, const int &amount)
{
    QJsonObject tran;
    tran.insert("code",  code);
    tran.insert("amount", amount);

    QJsonArray tranArry;
    tranArry.append( tran);

    qDebug() << QDateTime::currentDateTime();

    QString trans_id = QString::number(++g_num);

    json.insert( _ver, 1);
    json.insert( _reqtype, 72);
    json.insert( _clientReqCount, 1);
    json.insert( _store_id , g_stroid );
    json.insert( _station_id, g_station_id);
    json.insert( _operator_id, g_operator_id);
    json.insert( _trans_id, trans_id);
    json.insert( _transactions, tranArry);

    qDebug() << "json:" << json;
}

void Dialog::getRefundJson(QJsonObject &json, const QString &code, const int &amount)
{
//    if(!g_map.contains(code))
//    {
//        QMessageBox box;
//        box.setText("交易记录不存在!");

//        box.move(this->width()/2 - 120, this->height()/2 - 60);
//        box.exec();
//        return ;
//    }
    if(code == "")
    {
        QJsonArray tranArry;

        QJsonObject tran;
        tran.insert("fmId", code);
        tran.insert("refund_count", amount);
        tranArry.append( tran);

        qDebug() << QDateTime::currentDateTime();

        json.insert( _ver, 1);
        json.insert( _reqtype, 62);
        json.insert( _clientReqCount, 1);
        json.insert( _store_id , g_stroid );
        json.insert( _station_id, g_station_id);
        json.insert( _operator_id, g_operator_id);
        json.insert( _trans_id, ++g_num);
        json.insert( _transactions, tranArry);
        qDebug() << "json:" << json;
    }
    else if((code[0] >= 'a' && code[0] <= 'z') ||
       (code[0] >= 'A' && code[0] <= 'Z'))
    {
        QJsonArray tranArry;

        QJsonObject tran;
        tran.insert("fmId", code);
        tran.insert("refund_count", amount);
        tranArry.append( tran);

        qDebug() << QDateTime::currentDateTime();

        json.insert( _ver, 1);
        json.insert( _reqtype, 62);
        json.insert( _clientReqCount, 1);
        json.insert( _store_id , g_stroid );
        json.insert( _station_id, g_station_id);
        json.insert( _operator_id, g_operator_id);
        json.insert( _trans_id, ++g_num);
        json.insert( _transactions, tranArry);

        qDebug() << "json:" << json;
    }
    else
    {
        QStringList list = g_map.value(code);
        if(list.size() == 0)
           {
               list.append("");
               list.append("");
           }
        QJsonObject tran;
        tran.insert("paied_ebcode",  list[1]);
        tran.insert("paied_trans_id", code);
        tran.insert("refund_count", amount);

        QJsonArray tranArry;
        tranArry.append( tran);

        qDebug() << QDateTime::currentDateTime();

        json.insert( _ver, 1);
        json.insert( _reqtype, 62);
        json.insert( _clientReqCount, 1);
        json.insert( _store_id , g_stroid );
        json.insert( _station_id, g_station_id);
        json.insert( _operator_id, g_operator_id);
        json.insert( _trans_id, list[0].toInt());
        json.insert( _transactions, tranArry);

        qDebug() << "json:" << json;
    }

}

void Dialog::on_ok_clicked()
{
//    if(ui->txt_amount->text() == "" ||
//            ui->txt_paycode->text() == "")
//    {
//        QMessageBox box;
//        box.setText("金额和条码不能为空!");

//        box.move(this->width()/2 - 120, this->height()/2 - 60);
//        box.exec();
//        return ;
//    }

    if(ui->pushButton_2->isChecked())
    {
        float aa = ui->txt_amount->text().toFloat();

        int amount = (int)( (aa + 0.005) * 100) ;

        QString code = ui->txt_paycode->text();
        QJsonObject in_json, out_json;
        getPayJson( in_json, code , amount);

        bool res = WaitDialog::pay(  in_json, out_json, this);

    }
    else
    {
        float aa = ui->txt_amount->text().toFloat();

        int amount = (int)( (aa + 0.005) * 100) ;

        QString code = ui->txt_paycode->text();
        QJsonObject in_json, out_json;
        getRefundJson( in_json, code , amount);

        bool res = WaitDialog::refund(  in_json, out_json, this);


    }

}

void Dialog::on_ok2_clicked()
{
    ui->txt_amount->clear();
    ui->txt_paycode->clear();
    ui->stackedWidget->setCurrentIndex(0);
}

void Dialog::on_successjson_come(const mySock::RequstType type, const QJsonObject& json)
{
    float aa = ui->txt_amount->text().toFloat();

    int amount = (int)( (aa + 0.005) * 100) ;

    QJsonObject objson = json;

    if(type == mySock::Reject)
    {
        QStringList list = g_map.value(ui->txt_paycode->text());

        if(list.size() == 0)
        {
            list.append("");
            list.append("10000");
            list.append(QString::number(amount));
            list.append(ui->txt_paycode->text());
        }

        QString qd = "支付宝";

        if(list[1].compare("10004") == 0)
            qd = "微信";
        else if(list[1].compare("10000") == 0)
            qd = "未知";


        ui->suc2->setText("退款成功");
        ui->tlb1->setText("支付渠道");
        ui->lb1->setText(qd);
        ui->tlb2->setText("非码交易号");
        ui->lb2->setText(list[3]);
        ui->tlb3->setText("支付交易号");
        ui->lb3->setText(ui->txt_paycode->text());
        ui->tlb4->setText("退款金额");
        ui->lb4->setText(QString::number(list[2].toDouble()/100));
        ui->lb5->hide();
        ui->tlb5->hide();
        ui->lb6->hide();
        ui->tlb6->hide();
        ui->stackedWidget->setCurrentIndex(1);
    }
    else
    {

        ui->lb5->show();
        ui->tlb5->show();
        ui->lb6->show();
        ui->tlb6->show();

        QStringList list;
        list.append(QString::number(g_num));
        list.append(objson["pay_ebcode"].toString());
        list.append(QString::number(objson["alipay_amount"].toInt()));
        list.append(objson["fmId"].toString());
        g_map.insert(objson["pay_transId"].toString(), list);

        QStringList listtmp;
        listtmp.append(QString::number(g_num));
        listtmp.append(objson["pay_ebcode"].toString());
        listtmp.append(QString::number(objson["alipay_amount"].toInt()));
        listtmp.append(objson["fmId"].toString());
        g_map.insert(objson["fmId"].toString(), list);

        ui->suc2->setText("支付成功");
        ui->tlb1->setText("支付渠道");
        ui->lb1->setText(json["pay_id"].toString());
        ui->tlb2->setText("非码交易号");
        ui->lb2->setText(json["fmId"].toString());
        ui->tlb3->setText("支付交易号");
        ui->lb3->setText(json["pay_transId"].toString());
        ui->tlb4->setText("应付金额");
        ui->lb4->setText(QString::number(json["alipay_amount"].toDouble()/100));
        ui->tlb5->setText("优惠金额");
        ui->lb5->setText(QString::number(json["mcoupon_amount"].toDouble()/100));
        ui->tlb6->setText("实付金额");
        ui->lb6->setText(QString::number(json["alipay_amount"].toDouble()/100));
        ui->stackedWidget->setCurrentIndex(1);
    }
}

void Dialog::on_nodele_clicked()
{
    curTxt->setText(curTxt->text().left(curTxt->text().length() - 1));
}

void Dialog::txtFcous()
{
    curTxt = (LcMyLineEdit *)sender();
}

void Dialog::on_pushButton_clicked()
{
//    this->hide();
//    israise=true;
//    this->close();
    this->hide();
//    this->deleteLater();
}

//void Dialog::floatraise()
//{
//    if(israise)
//    {
//        //folatWidget->raise();
//    }
//}

void Dialog::on_pushButton_18_clicked()
{
    ui->txt_amount->clear();
}

void Dialog::on_pushButton_40_clicked()
{
    ui->txt_paycode->clear();
}

