#ifndef FMSOCKSERVER_H
#define FMSOCKSERVER_H

#define WIN32_LEAN_AND_MEAN


#include <Windows.h>
#include <winsock2.h>
#include <list>

#define BACKLOG 5

#define FMSOCKFLAG 0x4d46



#include "fmapirelay.h"
#include "fmapicfg.h"

//////////////////////////////////////////////////////////////////////////
//! Protocol header structure
typedef struct {
    UINT flag;
    UINT ver;
    UINT len;
}FMSOCKHEADER, *LPFMSOCKHEADER;


//! Protocol data structure
typedef struct
{
    WSAOVERLAPPED   overlap;    //! WSAOVERLAPPED object must be the first member
    WSABUF          buffer[2];  //! buffer[0] holds length
                                //! buffer[1] holds contents
          
    DWORD           flags;
    SOCKET          socket;
    FMApiRelay     *relay;

    FMSOCKHEADER    header;
    
    char            msg[1];
}FMSOCKDATA, *LPFMSOCKDATA;


//////////////////////////////////////////////////////////////////////////
//! Class FMSocketServer
//#ifdef __cplusplus
//extern "C" {
//#endif

class FMVIP_DECL FMSockServer
{
public:
    explicit        FMSockServer(FMApiRelay *relay = NULL);
    ~FMSockServer();

    VOID            Listen(USHORT port);
    BOOL            Stop();

    VOID            SetRelay(FMApiRelay* relay);


protected:
    BOOL            _Listen();

    static DWORD WINAPI     RecvWorker(LPVOID param);
    //! Completion routine
    static void CALLBACK    RecvRoutine(DWORD err, DWORD bytes, LPWSAOVERLAPPED overlapped, DWORD flags);
private:
    SOCKET              _socket;
    USHORT              _port;
    sockaddr_in         _addr_in;
    HANDLE              _worker;
    FMApiRelay         *_relay;
    CRITICAL_SECTION    _cs;
};

//#ifdef __cplusplus
//}
//#endif

#endif // FMSOCKSERVER_H