#include "fmapirelay.h"
#include "fmapidef.h"
#include "fmhttpclient.h"
#include <fmutils/fmutils.hpp>

#include <rapidjson/document.h>
#include <rapidjson/writer.h>
#include <rapidjson/stringbuffer.h>

using namespace rapidjson;

FMApiRelay::FMApiRelay() : 
    _response(0),
    _request(0)
{

}

FMApiRelay::~FMApiRelay()
{
    FM_ARRAY_FREE(_response);
    FM_ARRAY_FREE(_request);
}

BOOL FMApiRelay::Transfer( LPSTR data, LPSTR &rsp, UINT &rsp_len )
{
    int err_code = _ParseRequest(data);
    if (FM_API_SUCCESS != err_code) {
        FMLOG(_T("Invalid request data."));
        _SimpleResponse(err_code, rsp, rsp_len);
        return FALSE;
    }

    _GetResponse(rsp, rsp_len);

    return TRUE;
}


INT FMApiRelay::_ParseRequest(LPSTR data)
{
    Document json;
    json.Parse(data);
    
    if (json.IsNull() || json.HasParseError()) {
        return FM_API_BADJSON;
    }

    Document json_fm;
    json_fm.SetObject();
    FMApiPropMap *pm = _cfg.GetPropsMap();
    if (pm && pm->size() > 0) {
        FMApiPropMap::iterator iter = pm->begin();
        for(; iter != pm->end(); ++iter) {
            if (json.HasMember(iter->first)) {
                Value &v = json[iter->first];
                json_fm.AddMember(StringRef(iter->second), v, json_fm.GetAllocator());
            }
        }
    }
    
    StringBuffer buffer;
    Writer<StringBuffer> writer(buffer);
    json_fm.Accept(writer);
    FMLOG("Parsed data %s => %s", data, buffer.GetString());

    FM_ARRAY_FREE(_request);
    int len = buffer.GetSize() + 1;
    _request = new char[len];
    strcpy_s(_request, len, buffer.GetString());
    

    return FM_API_SUCCESS;
}

BOOL FMApiRelay::_GetResponse( LPSTR &rsp, UINT &len )
{
    FMHttpClient http(_cfg.GetTransUrlFormat());
    http.SetHeaders(L"Content-Type: application/json;");
    if (http.Send(_request, 0, FMHttpClient::FMHTTP_POST)) {
        const char *resp = http.Read();
        FM_ARRAY_FREE(_response);
        int l = strlen(resp) + 1;
        _response = new char[l];
        rsp = _response;
        len = l;
        strcpy_s(_response, len, resp);
        return TRUE;
    }
    else {
        return _SimpleResponse(FM_API_ERROR, rsp, len);
    }
}

BOOL FMApiRelay::_SimpleResponse(int code, LPSTR &rsp, UINT &len)
{
    FM_ARRAY_FREE(_response);
    len = 64;
    _response = new char[len];
    rsp = _response;

    sprintf_s(rsp, len, "{\"statusCode\":%d, \"msg\":\"%s\"}", code, fm_error.at(code));

    return TRUE;
}
