#ifndef FMAPIDEF_H
#define FMAPIDEF_H

#ifdef FMSOCK_BUILD
#define FMVIP_DECL __declspec(dllexport)
#else
#define FMVIP_DECL __declspec(dllimport)
#endif

#include <Windows.h>
#include <map>
#include <string>

#define FM_PROPS_SECTION "PropsMap"
#define FM_TRANS_URL     "TransUrl"
#define FM_PATH_DELIM    '\\'
#define FM_DOT_DELIM     '.'
#define FM_EQU_DELIM     '='
#define FM_CFG_SUFFIX    ".cfg"

#define FM_ARRAY_FREE(p)    if (p) {\
                                delete []p;\
                                p = NULL;\
                            }


//////////////////////////////////////////////////////////////////////////
enum {
    FM_API_SUCCESS = 100,
    FM_API_ERROR,
    FM_API_TIMEOUT,
    FM_API_BADJSON
};

typedef std::map<const int, LPCSTR> FMErrorMap;

const FMErrorMap::value_type fm_error_pairs[] = 
{
    FMErrorMap::value_type(FM_API_SUCCESS, "Success"),
    FMErrorMap::value_type(FM_API_ERROR, "Error"),
    FMErrorMap::value_type(FM_API_TIMEOUT, "Timeout"),
    FMErrorMap::value_type(FM_API_BADJSON, "Invalid json data")
};

const FMErrorMap fm_error(fm_error_pairs, fm_error_pairs + (sizeof fm_error_pairs / sizeof fm_error_pairs[0]));

//////////////////////////////////////////////////////////////////////////

template <typename T> static inline T *fmGetPtrHelper(T *ptr) { return ptr; }
template <typename Wrapper> static inline typename Wrapper::pointer fmGetPtrHelper(const Wrapper &p) { return p.data(); }

#define FM_DECLARE_PRIVATE(Class) \
    inline Class##Private* d_func() { return reinterpret_cast<Class##Private *>(fmGetPtrHelper(d_ptr)); } \
    inline const Class##Private* d_func() const { return reinterpret_cast<const Class##Private *>(fmGetPtrHelper(d_ptr)); } \
    friend class Class##Private;

#define FM_DECLARE_PRIVATE_D(Dptr, Class) \
    inline Class##Private* d_func() { return reinterpret_cast<Class##Private *>(Dptr); } \
    inline const Class##Private* d_func() const { return reinterpret_cast<const Class##Private *>(Dptr); } \
    friend class Class##Private;

#define FM_DECLARE_PUBLIC(Class)                                    \
    inline Class* q_func() { return static_cast<Class *>(q_ptr); } \
    inline const Class* q_func() const { return static_cast<const Class *>(q_ptr); } \
    friend class Class;

#define FM_D(Class) Class##Private * const d = d_func()
#define FM_Q(Class) Class * const q = q_func()


#endif //! FMAPIDEF_H