#ifndef FMVIPWND_H
#define FMVIPWND_H

#include <QWidget>
#include <QJsonObject>
#include <QDebug>

class FMVipWnd : public QWidget
{
    Q_OBJECT
public:
    explicit FMVipWnd(QWidget *parent = 0);

    //! Set current user profile (Json data)
    bool    setProfile(const QByteArray&);

public slots:
    void    on_close_btn_clicked();
#ifdef Q_OS_WIN
protected:
    bool    nativeEvent(const QByteArray &eventType, void *message, long *result);
    void    paintEvent(QPaintEvent *event);
protected:
    long    winNCHitTest(MSG *msg);

protected:
    QJsonObject     _profile_obj;
#endif
};

#endif // FMVIPWND_H
