#include "fmviplogin.h"
#include "ui_fmviplogin.h"
#include "fmvippanel.h"
#include <QFile>
#include <QJsonDocument>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QNetworkAccessManager>

FMVipLogin::FMVipLogin(QWidget *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipLogin)
{
    ui->setupUi(this);
}

FMVipLogin::~FMVipLogin()
{
    qDebug() << __FUNCTION__;
    delete ui;
}

void FMVipLogin::on_login_btn_clicked()
{
    qDebug() << __FUNCTION__;
    QString id = ui->login_edit->text();

    QNetworkAccessManager *net = new QNetworkAccessManager(this);
    connect(net, SIGNAL(finished(QNetworkReply*)), this, SLOT(on_login_result(QNetworkReply*)));
    QNetworkRequest req(QUrl("http://jtest.freemudvip.com/member_show/service/restful/pos"));

    net->get(req);
}

void FMVipLogin::on_login_result(QNetworkReply *reply)
{
    qDebug() << __FUNCTION__;
    QJsonDocument json = QJsonDocument::fromJson(reply->readAll());

    QFile user(":/data/user");
    if (user.open(QFile::ReadOnly)) {
        if (ui->login_edit->text() == user.readAll()) {
            FMVipPanel *panel = new FMVipPanel;
            QFile file(":/data/profile");
            if (file.open(QFile::ReadOnly)) {
                panel->setProfile(file.readAll());

                panel->show();
                close();
                emit loginSuccess();
            }
            else {
                qDebug() << "Failed opening file: " << file.fileName();
            }
        }
        else {
            qDebug() << "User not authorized.";
        }
    }
    else {
        qDebug() << "Failed opening file: " << user.fileName();
    }
}
