#include "fmvipfund.h"
#include "ui_fmvipfund.h"
#include <QButtonGroup>

FMVipFund::FMVipFund(QWidget *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipFund),
    _digit_group(new QButtonGroup(this))
{
    ui->setupUi(this);
    _digit_group->addButton(ui->half);
    _digit_group->addButton(ui->one);
    _digit_group->addButton(ui->two);
    _digit_group->addButton(ui->five);
    _digit_group->addButton(ui->ten);
    _digit_group->addButton(ui->twenty);

    connect(_digit_group, SIGNAL(buttonClicked(QAbstractButton*)), SLOT(onDigitChecked(QAbstractButton*)));
}

FMVipFund::~FMVipFund()
{
    delete ui;
}

void FMVipFund::show()
{
    qDebug() << __FUNCTION__;
    ui->id_label->setText(_profile_obj["member_id"].toString());
    ui->name_label->setText(_profile_obj["member_name"].toString());
    ui->balance_label->setText(QString::number(_profile_obj["balance"].toInt()));
    ui->operator_label->setText(_profile_obj["operator_id"].toString());
    ui->bd_label->setText(_profile_obj["business_date"].toString());

    FMVipWnd::show();
}

void FMVipFund::onDigitChecked(QAbstractButton *btn)
{
    QString digit = btn->text();
    digit = digit.replace("￥", "");
    ui->amount_edit->setText(digit);
}

void FMVipFund::on_fund_btn_clicked()
{
    qDebug() << __FUNCTION__;
}
