#ifndef FMVIPDISPATCHER_H
#define FMVIPDISPATCHER_H

#include <QObject>
#include "fmapirelay.h"

#define FM_VIP_QUERY    1001
#define FM_VIP_FUND     1002
#define FM_VIP_PAY      1003
#define FM_VIP_REVOKE   1004
#define _DEBUG

class FMVipWnd;

class FMVipDispatcher : public QObject, public FMApiRelay
{
    Q_OBJECT
public:
    explicit            FMVipDispatcher(QObject *parent = 0);

protected:
    virtual INT         _ParseRequest(LPSTR data);
    virtual BOOL        _GetResponse(LPSTR &rsp, UINT &len);

signals:
    void                requested(const QByteArray &);
    void                responded(const QByteArray &);

private slots:
    void                onRequest(const QByteArray &);
    void                onResponse(const QByteArray &);
    void                onFinished();

private:
    FMVipWnd           *_vindow;
};

#endif // FMVIPDISPATCHER_H
