#include "fmvipdispatcher.h"
#include "fmvippanel.h"
#include "fmvippanel.h"
#include "fmviporder.h"
#include <QDebug>
#include <QJsonDocument>
#include <QJsonObject>
#include <QApplication>

FMVipDispatcher::FMVipDispatcher(QObject *parent)
    : QObject(parent),
      FMApiRelay(),
      _vindow(0)
{
    connect(this, SIGNAL(requested(QByteArray)), SLOT(onRequest(QByteArray)));
    connect(this, SIGNAL(responded(QByteArray)), SLOT(onResponse(QByteArray)));
}

INT FMVipDispatcher::_ParseRequest(LPSTR data)
{
    int res = FMApiRelay::_ParseRequest(data);

    QByteArray req(_request);
    emit requested(req);

    return res;
}

BOOL FMVipDispatcher::_GetResponse(LPSTR &rsp, UINT &len)
{
    BOOL res = FMApiRelay::_GetResponse(rsp, len);

    QByteArray reply(_response);
    emit responded(reply);

    return res;
}

void FMVipDispatcher::onRequest(const QByteArray &req)
{
    QJsonDocument json = QJsonDocument::fromJson(req);
    if (!json.isNull() && !json.isEmpty()) {
        QJsonObject obj = json.object();
        if (!obj.isEmpty()) {
            QJsonValue v = obj["reqType"];
            if (v.toInt() == FM_VIP_QUERY) {
                qDebug() << "Query" << req;
                if (!_vindow) {
                    FMVipPanel *panel = new FMVipPanel;
                    connect(panel, SIGNAL(destroyed(QObject*)), SLOT(onFinished()));
                    _vindow = panel;
                    panel->show();
                }
            }
            else if (v.toInt() == FM_VIP_PAY) {
                qDebug() << "Payment" << req;
                if (!_vindow) {
                    FMVipOrder *order = new FMVipOrder;
                    connect(order, SIGNAL(destroyed(QObject*)), SLOT(onFinished()));
                    _vindow = order;
                    order->show();
                }
            }
#ifdef _DEBUG
            else if (v.toInt() == -1) {
                qDebug() << "Quit";
                qApp->quit();
            }
#endif
        }
    }
}

void FMVipDispatcher::onResponse(const QByteArray &)
{
    qDebug() << __FUNCTION__;
}

void FMVipDispatcher::onFinished()
{
    qDebug() << __FUNCTION__;
    _vindow = 0;
}
