#include "fmsockserver.h"
#include "fmvipdispatcher.h"
#include <QApplication>
#include <QFile>
#include <QTextStream>
#include <QDateTime>

bool checkOnly()
{
    HANDLE m_hMutex  =  CreateMutex(NULL, FALSE,  L"fm_vip" );

    if  (GetLastError()  ==  ERROR_ALREADY_EXISTS)  {
        CloseHandle(m_hMutex);
        m_hMutex  =  NULL;
        return  false;
    }
    else
        return true;
}

#if defined  Q_OS_LINUX   //for linux
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
bool checkOnly()
{
    const char filename[]  = "/tmp/lockfile_fm_vip";
    int fd = open (filename, O_WRONLY | O_CREAT , 0644);
    int flock = lockf(fd, F_TLOCK, 0 );
    if (fd == -1) {
        perror("open lockfile/n");
        return false;
    }
    //给文件加锁
    if (flock == -1) {
        perror("lock file error/n");
        return false;
    }
    //程序退出后，文件自动解锁
    return true;
}
#endif

void customMessageHandler(QtMsgType type,const QMessageLogContext& Context, const QString &msg)
{
    Q_UNUSED(Context);
    QString txt;
    switch (type) {
    case QtDebugMsg:
        txt = QString("Debug: %1").arg(msg);
        break;
    case QtWarningMsg:
        txt = QString("Warning: %1").arg(msg);
        break;
    case QtCriticalMsg:
        txt = QString("Critical: %1").arg(msg);
        break;
    case QtFatalMsg:
        txt = QString("Fatal: %1").arg(msg);
        abort();
    }

    QString strDateTime = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss ddd");

    QFile outFile("debuglog.txt");
    outFile.open(QIODevice::WriteOnly | QIODevice::Append);
    QTextStream ts(&outFile);
    ts << strDateTime << txt << "\r\n";
    outFile.flush();
    outFile.close();
}

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    if(checkOnly()==false)
        return 0;

    qInstallMessageHandler(customMessageHandler);

    FMVipDispatcher relay;
    FMSockServer server(&relay);

    server.Listen(23770);

    return a.exec();
}
