#ifndef FMVIPWND_H
#define FMVIPWND_H

#include <QDialog>
#include <QJsonObject>
#include <QMap>
#include <QDebug>
#include "fmloading.h"

class FMVipWnd : public QDialog
{
    Q_OBJECT
public:
    explicit FMVipWnd(QDialog *parent = 0);
    ~FMVipWnd();

    //! Set current user profile (Json data)
    bool    setProfile(const QByteArray&);
    void    setIsBusy(const bool isBusy = true);
    virtual void    resetWnd(){}

    int     exec();
signals:
    void    doPost();
public slots:
    void    on_close_btn_clicked();
private:
    FMLoading*  loadingWindow;
protected:
    QJsonObject     _profile_obj;
    bool            _isBusy;
    void            reject();
#ifdef Q_OS_WIN
protected:
    bool    nativeEvent(const QByteArray &eventType, void *message, long *result);
    void    paintEvent(QPaintEvent *event);
protected:
    long    winNCHitTest(MSG *msg);

#endif
};

#endif // FMVIPWND_H
